/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class CSVFile {
    private String separator = ";";
    private BufferedReader reader = null;
    private String currentLine = null;
    private boolean recall = false;
    private boolean prev = false;

    public CSVFile(InputStream file) {
        this(file, null);
    }

    public CSVFile(InputStream file, String separator) {
        this.reader = new BufferedReader(new InputStreamReader(file));
        if (separator != null) {
            this.separator = separator;
        }
    }

    public CSVFile(InputStream file, String separator, String encoding) throws UnsupportedEncodingException {
        this.reader = new BufferedReader(new InputStreamReader(file, encoding));
        if (separator != null) {
            this.separator = separator;
        }
    }

    public synchronized boolean hasNext() throws IOException {
        if (this.recall) {
            return this.prev;
        }
        this.currentLine = this.reader.readLine();
        this.prev = this.currentLine != null;
        this.recall = true;
        return this.prev;
    }

    public synchronized String[] next() throws IOException {
        if (!this.hasNext()) {
            throw new IOException("no more lines");
        }
        String[] cols = this.currentLine.split(this.separator + "(?=([^\"]*\"[^\"]*\")*(?![^\"]*\"))");
        this.recall = false;
        return cols;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

